/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.tasklist;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.servlet.pmod.ModelEnabledBean;
import com.ibm.hwmca.fw.servlet.pmod.PanelModel;
import com.ibm.hwmca.fw.servlet.pmod.PmDataBean;
import com.ibm.hwmca.fw.servlet.pmod.datamodel.PmListModel;
import com.ibm.hwmca.fw.servlet.pmod.datamodel.PmTableModel;
import com.ibm.hwmca.fw.servlet.pmod.datamodel.PmTreeModel;
import com.ibm.hwmca.fw.servlet.pmod.event.ModelActionEvent;
import com.ibm.hwmca.fw.servlet.pmod.event.ModelActionListener;
import com.ibm.hwmca.fw.servlet.pmod.task.PanelModelTaskPortal;
import com.ibm.hwmca.fw.servlet.pmod.task.TaskEndedException;
import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.servlet.util.HMCSessionLifeListener;
import com.ibm.hwmca.fw.servlet.util.HMCSessionListener;
import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.task.PresentationTask;
import com.ibm.hwmca.fw.task.PresentationTaskParms;
import com.ibm.hwmca.fw.tasklet.Client;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.tasklet.TaskletRequest;
import com.ibm.hwmca.fw.tasklet.TaskletResponse;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import javax.servlet.http.HttpSession;

public class TaskList
extends PresentationTask
implements PmDataBean,
ModelActionListener,
ModelEnabledBean {
    private static final String TRACE_MASKT = "XTKLTSKT";
    private static final String RESOURCE_BUNDLE = "com.ibm.hwmca.fw.tasklist.res.tasklist";
    private static final String MANAGER_SERVICE_TASKLET = "com.ibm.hwmca.fw.tasklist.ManagerService";
    public static final short CLIENT_RUN_ERROR = 1;
    private boolean privileged;
    private boolean taskCompleted;
    private Locale clientLocale;
    ResourceBundle resources;
    DateFormat dateformatter;
    protected PanelModel mainPanelModel;
    protected UsersModel usersModel;
    protected TasksModel tasksModel;
    protected Client managerService;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Long;

    public TaskList(PresentationTaskParms parms) {
        super(parms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object runTask() throws Exception {
        try {
            ClientUserContext userContext = this.getHMCSession().getUserContext();
            this.clientLocale = userContext.getLocale();
            this.resources = ResourceBundle.getBundle(RESOURCE_BUNDLE, this.clientLocale);
            this.dateformatter = DateFormat.getDateTimeInstance(3, 3, this.clientLocale);
            this.dateformatter.setTimeZone(userContext.getTimeZone());
            this.managerService = new Client(MANAGER_SERVICE_TASKLET, null);
            this.managerService.init();
            this.checkPrivileged();
            this.showMainPanel();
            Object var2_2 = null;
            return var2_2;
        }
        finally {
            if (this.managerService != null) {
                this.managerService.terminate();
            }
            if (this.usersModel != null) {
                HMCSession.removeHMCSessionLifeListener(this.usersModel);
                this.usersModel.prepareForTaskEnd();
            }
            if (this.tasksModel != null) {
                this.tasksModel.prepareForTaskEnd();
            }
        }
    }

    protected void showMainPanel() {
        this.tasksModel = new TasksModel();
        if (this.privileged) {
            this.usersModel = new UsersModel();
            HMCSession.addHMCSessionLifeListener(this.usersModel);
        } else {
            this.tasksModel.setSession(this.getHMCSession());
        }
        this.mainPanelModel = new PanelModel("com.ibm.hwmca.fw.tasklist.res.main", RESOURCE_BUNDLE, this, this.getHMCSession().getUserContext().getLocales());
        this.mainPanelModel.addModelActionListener(this);
        this.mainPanelModel.render();
        this.waitForTaskToFinish();
    }

    public void logException(Throwable throwable) {
        FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "TaskListTask");
        new FrameworkLog(classLogInfo, 1, throwable).log();
    }

    protected void forceTermination(String reason) {
        this.markTaskCompleted();
    }

    protected void processNewUser() {
        this.tasksModel.setSessions(this.usersModel.getSelectedSessions());
    }

    protected void processLogoff() {
        List sessions = this.usersModel.getSelectedSessions();
        if (sessions.isEmpty()) {
            return;
        }
        LocalizableText[] buttons = new LocalizableText[]{CommonMsgInterface.YES_BUTTON, CommonMsgInterface.NO_BUTTON};
        LocalizableText title = new LocalizableText(RESOURCE_BUNDLE, "logoffConfirmationTitle");
        MessageText message = new MessageText(RESOURCE_BUNDLE, "logoffConfirmationMessage", new Object[]{new Integer(sessions.size())});
        try {
            LocalizableText button = CommonMsgApp.showMessageBox(null, title, message, MsgType.QUESTION_MESSAGE, buttons);
            if (button != CommonMsgInterface.YES_BUTTON) {
                return;
            }
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKT, "Exception rendering \"logoff confirmation\" message.");
            Trace.trace(TRACE_MASKT, e);
            return;
        }
        Iterator iterator = sessions.iterator();
        while (iterator.hasNext()) {
            HMCSession hmcSession = (HMCSession)iterator.next();
            HttpSession httpSession = hmcSession.getHttpSession();
            hmcSession.destroy();
            httpSession.invalidate();
        }
        this.usersModel.refreshUsers();
    }

    protected void processDisconnect() {
        List sessions = this.usersModel.getSelectedSessions();
        if (sessions.isEmpty()) {
            return;
        }
        LocalizableText[] buttons = new LocalizableText[]{CommonMsgInterface.YES_BUTTON, CommonMsgInterface.NO_BUTTON};
        LocalizableText title = new LocalizableText(RESOURCE_BUNDLE, "disconnectConfirmationTitle");
        MessageText message = new MessageText(RESOURCE_BUNDLE, "disconnectConfirmationMessage", new Object[]{new Integer(sessions.size())});
        try {
            LocalizableText button = CommonMsgApp.showMessageBox(null, title, message, MsgType.QUESTION_MESSAGE, buttons);
            if (button != CommonMsgInterface.YES_BUTTON) {
                return;
            }
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKT, "Exception rendering \"disconnect confirmation\" message.");
            Trace.trace(TRACE_MASKT, e);
            return;
        }
        Iterator iterator = sessions.iterator();
        while (iterator.hasNext()) {
            HMCSession hmcSession = (HMCSession)iterator.next();
            if (hmcSession.isDisconnected()) continue;
            hmcSession.disconnectFromWebSession();
        }
        this.usersModel.refreshUsers();
    }

    protected void processSwitchToTask() {
        PanelModelTaskPortal portal = this.tasksModel.getSelectedTask();
        if (portal == null) {
            return;
        }
        if (portal.getHMCSession() != this.getHMCSession()) {
            try {
                LocalizableText[] buttons = new LocalizableText[]{CommonMsgInterface.OK_BUTTON};
                LocalizableText title = new LocalizableText(RESOURCE_BUNDLE, "cantSwitchToOtherSessionTitle");
                MessageText message = new MessageText(RESOURCE_BUNDLE, "cantSwitchToOtherSessionMessage");
                CommonMsgApp.showMessageBox(null, title, message, MsgType.WARNING_MESSAGE, buttons);
                return;
            }
            catch (HException e) {
                Trace.trace(TRACE_MASKT, "Exception rendering \"can't switch\" message.");
                Trace.trace(TRACE_MASKT, e);
                return;
            }
        }
        boolean noPanels = false;
        try {
            noPanels = portal.isPanelStackEmpty();
        }
        catch (TaskEndedException e) {
            noPanels = true;
        }
        if (noPanels) {
            try {
                LocalizableText[] buttons = new LocalizableText[]{CommonMsgInterface.OK_BUTTON};
                LocalizableText title = new LocalizableText(RESOURCE_BUNDLE, "cantSwitchToPanelessTaskTitle");
                MessageText message = new MessageText(RESOURCE_BUNDLE, "cantSwitchToPanelessTaskMessage");
                CommonMsgApp.showMessageBox(null, title, message, MsgType.WARNING_MESSAGE, buttons);
                return;
            }
            catch (HException e) {
                Trace.trace(TRACE_MASKT, "Exception rendering \"no panels\" message.");
                Trace.trace(TRACE_MASKT, e);
                return;
            }
        }
        portal.requestFocus();
    }

    protected void processTerminateTask() {
        PanelModelTaskPortal portal = this.tasksModel.getSelectedTask();
        if (portal == null) {
            return;
        }
        LocalizableText[] buttons = new LocalizableText[]{CommonMsgInterface.YES_BUTTON, CommonMsgInterface.NO_BUTTON};
        LocalizableText title = new LocalizableText(RESOURCE_BUNDLE, "terminateTaskTitle");
        MessageText message = new MessageText(RESOURCE_BUNDLE, "terminateTaskMessage", new Object[]{this.tasksModel.getTaskName(portal.getPresentationTask())});
        try {
            LocalizableText button = CommonMsgApp.showMessageBox(null, title, message, MsgType.QUESTION_MESSAGE, buttons);
            if (button != CommonMsgInterface.YES_BUTTON) {
                return;
            }
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKT, "Exception rendering \"task termination\" message.");
            Trace.trace(TRACE_MASKT, e);
            return;
        }
        portal.getPresentationTask().forceTaskToTerminate("Terminated from Task List task by user " + this.getHMCSession().getUserContext().getUserName());
        this.tasksModel.refreshTasks();
    }

    public void actionPerformed(ModelActionEvent event) {
        String command = event.getActionCommand();
        Trace.trace(TRACE_MASKT, "Processing TaskList action command \"" + command + "\".");
        if (command.equals("newUser")) {
            this.processNewUser();
        } else if (command.equals("logoff")) {
            this.processLogoff();
        } else if (command.equals("disconnect")) {
            this.processDisconnect();
        } else if (command.equals("switchTo")) {
            this.processSwitchToTask();
        } else if (command.equals("terminate")) {
            this.processTerminateTask();
        } else if (command.equals("close")) {
            this.markTaskCompleted();
        }
    }

    private synchronized void waitForTaskToFinish() {
        Trace.trace(TRACE_MASKT, "TaskList waiting for user to close the task.");
        while (!this.taskCompleted) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    private synchronized void markTaskCompleted() {
        this.taskCompleted = true;
        this.mainPanelModel.dispose();
        this.notifyAll();
    }

    public PmListModel getListModel(String modelName) {
        return null;
    }

    public PmTableModel getTableModel(String modelName) {
        if (this.privileged && modelName.equals("users")) {
            return this.usersModel;
        }
        if (modelName.equals("tasks")) {
            return this.tasksModel;
        }
        return null;
    }

    public PmTreeModel getTreeModel(String modelName) {
        return null;
    }

    protected void checkPrivileged() throws TaskletException {
        String mode = (String)this.getParms().getData("mode");
        if (mode != null && mode.equalsIgnoreCase("justtasks")) {
            return;
        }
        TaskletRequest request = new TaskletRequest();
        request.setData("operation", "isPrivileged");
        TaskletResponse response = this.managerService.request(request);
        this.privileged = (Boolean)response.getData("privileged");
        Trace.trace(TRACE_MASKT, "User privileged status == " + this.privileged);
    }

    public boolean isPrivileged() {
        return this.privileged;
    }

    public String getUserName() {
        return this.getHMCSession().getUserContext().getUserName();
    }

    public String getLoginTime() {
        return this.dateformatter.format(this.getHMCSession().getCreationTime());
    }

    private String localize(String messageKey) {
        return this.localize(messageKey, null);
    }

    private String localize(String messageKey, Object[] substitutionData) {
        String messagePattern = this.resources.getString(messageKey);
        MessageFormat message = new MessageFormat(messagePattern, this.clientLocale);
        return message.format(substitutionData, new StringBuffer(), (FieldPosition)null).toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class TasksModel
    implements PmTableModel,
    HMCSessionListener {
        List hmcSessions;
        List tasks;
        int selectedRowIndex = -1;
        String idHeader;
        String nameHeader;
        String targetsHeader;
        String startTimeHeader;
        WeakHashMap objectIdToName = new WeakHashMap();

        TasksModel() {
            this.idHeader = TaskList.this.resources.getString("taskIdHeader");
            this.nameHeader = TaskList.this.resources.getString("nameHeader");
            this.targetsHeader = TaskList.this.resources.getString("targetsHeader");
            this.startTimeHeader = TaskList.this.resources.getString("startTimeHeader");
        }

        void setSession(HMCSession hmcSession) {
            ArrayList<HMCSession> sessions = new ArrayList<HMCSession>(1);
            sessions.add(hmcSession);
            this.setSessions(sessions);
        }

        void setSessions(List hmcSessions) {
            this.deregisterListeners();
            this.hmcSessions = hmcSessions;
            this.registerListeners();
            this.refreshTasks();
        }

        private void deregisterListeners() {
            if (this.hmcSessions != null && !this.hmcSessions.isEmpty()) {
                Iterator iterator = this.hmcSessions.iterator();
                while (iterator.hasNext()) {
                    HMCSession hmcSession = (HMCSession)iterator.next();
                    hmcSession.removeHMCSessionListener(this);
                }
            }
        }

        private void registerListeners() {
            if (this.hmcSessions != null && !this.hmcSessions.isEmpty()) {
                Iterator iterator = this.hmcSessions.iterator();
                while (iterator.hasNext()) {
                    HMCSession hmcSession = (HMCSession)iterator.next();
                    hmcSession.addHMCSessionListener(this);
                }
            }
        }

        void prepareForTaskEnd() {
            this.deregisterListeners();
        }

        synchronized void refreshTasks() {
            Object selectedTask = this.selectedRowIndex == -1 ? null : this.tasks.get(this.selectedRowIndex);
            this.tasks = new ArrayList();
            Iterator iterator = this.hmcSessions.iterator();
            while (iterator.hasNext()) {
                HMCSession hmcSession = (HMCSession)iterator.next();
                this.tasks.addAll(hmcSession.getRunningTasks());
            }
            Collections.sort(this.tasks, new Comparator(this){
                private final /* synthetic */ TasksModel this$1;
                {
                    this.this$1 = this$1;
                }

                public int compare(Object o1, Object o2) {
                    return ((PanelModelTaskPortal)o1).getPresentationTask().getStartTime().compareTo(((PanelModelTaskPortal)o2).getPresentationTask().getStartTime());
                }
            });
            this.selectedRowIndex = selectedTask != null ? this.tasks.indexOf(selectedTask) : -1;
        }

        PanelModelTaskPortal getSelectedTask() {
            if (this.selectedRowIndex == -1) {
                return null;
            }
            return (PanelModelTaskPortal)this.tasks.get(this.selectedRowIndex);
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public int getRowCount() {
            return this.tasks.size();
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.idHeader;
                }
                case 1: {
                    return this.nameHeader;
                }
                case 2: {
                    return this.targetsHeader;
                }
                case 3: {
                    return this.startTimeHeader;
                }
            }
            return null;
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return class$java$lang$Long == null ? (class$java$lang$Long = TaskList.class$("java.lang.Long")) : class$java$lang$Long;
            }
            return class$java$lang$String == null ? (class$java$lang$String = TaskList.class$("java.lang.String")) : class$java$lang$String;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            PanelModelTaskPortal portal = (PanelModelTaskPortal)this.tasks.get(rowIndex);
            PresentationTask task = portal.getPresentationTask();
            switch (columnIndex) {
                case 0: {
                    return new Long(task.getTaskId());
                }
                case 1: {
                    return this.getTaskName(task);
                }
                case 2: {
                    return this.getTaskTargets(task);
                }
                case 3: {
                    return TaskList.this.dateformatter.format(task.getStartTime());
                }
            }
            return null;
        }

        String getTaskName(PresentationTask task) {
            UIInfo taskInfo;
            PresentationTaskParms parms = task.getParms();
            if (parms != null && (taskInfo = parms.getUIInfo()) != null) {
                return this.formatString(taskInfo.getName(TaskList.this.clientLocale));
            }
            return task.getClass().getName();
        }

        private String formatString(String text) {
            if (text.indexOf(10) == -1) {
                return text;
            }
            return text.replace('\n', ' ');
        }

        /*
         * Unable to fully structure code
         */
        private String getTaskTargets(PresentationTask task) {
            block17: {
                parms = task.getParms();
                if (parms == null) {
                    return "";
                }
                targets = parms.getTargetIds();
                if (targets == null || targets.length == 0) {
                    return "";
                }
                names = new String[targets.length];
                unknownTargets = null;
                i = 0;
                while (i < targets.length) {
                    target = targets[i];
                    names[i] = (String)this.objectIdToName.get(target);
                    if (names[i] == null) {
                        if (unknownTargets == null) {
                            unknownTargets = new ArrayList<ObjectId>(targets.length);
                        }
                        unknownTargets.add(target);
                    }
                    ++i;
                }
                if (unknownTargets != null) {
                    Trace.trace("XTKLTSKT", "Using manager to resolve " + unknownTargets.size() + " targets out of " + targets.length);
                    try {
                        targetsToSend = new ObjectId[unknownTargets.size()];
                        unknownTargets.toArray(targetsToSend);
                        request = new TaskletRequest();
                        request.setData("operation", "translateTargets");
                        request.setData("targets", targetsToSend);
                        response = TaskList.this.managerService.request(request);
                        newNames = (String[])response.getData("targets");
                        i = 0;
                        j = 0;
                        while (i < targets.length) {
                            if (names[i] == null) {
                                names[i] = newNames[j];
                                this.objectIdToName.put(targets[i], newNames[j++]);
                            }
                            ++i;
                        }
                        break block17;
                    }
                    catch (TaskletException e) {
                        unknown = TaskList.access$000(TaskList.this, "unknown");
                        i = 0;
                        j = false;
                        ** while (i < targets.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (names[i] == null) {
                            names[i] = unknown;
                        }
                        ++i;
                        continue;
lbl50:
                        // 1 sources

                        break block17;
                    }
                }
                Trace.trace("XTKLTSKT", "Resolved all " + targets.length + " targets from lookaside map");
            }
            if (names == null || names.length == 0) {
                return "";
            }
            if (names.length == 1) {
                return names[0] != null ? this.formatString(names[0]) : TaskList.access$000(TaskList.this, "unknown");
            }
            work = new StringBuffer();
            i = 0;
            while (i < names.length) {
                work.append(names[i] != null ? this.formatString(names[i]) : TaskList.access$000(TaskList.this, "unknown"));
                if (i < names.length - 1) {
                    work.append(", ");
                }
                if (work.length() > 50) {
                    work.append(TaskList.access$100(TaskList.this, "moreTargets", new Object[]{new Integer(names.length - i - 1)}));
                    break;
                }
                ++i;
            }
            return work.toString();
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            throw new UnsupportedOperationException();
        }

        public void setSelected(int[] selected) {
            this.selectedRowIndex = selected.length == 0 ? -1 : selected[0];
        }

        public int[] getSelected() {
            if (this.selectedRowIndex == -1) {
                return new int[0];
            }
            return new int[]{this.selectedRowIndex};
        }

        public void sessionDisconnected(HMCSession session) {
        }

        public void sessionConnected(HMCSession session) {
        }

        public void sessionDestroyed(HMCSession session) {
        }

        public void clientConnectivityLost(HMCSession session) {
        }

        public void clientConnectivityGained(HMCSession session) {
        }

        private void asynchronouslyRefreshTasks() {
            Thread thread = new Thread(new Runnable(this){
                private final /* synthetic */ TasksModel this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    this.this$1.refreshTasks();
                    TasksModel.access$400((TasksModel)this.this$1).mainPanelModel.refresh();
                }
            }, "TaskList asynchronous task refresh for TaskList task " + TaskList.this.getTaskId());
            thread.setDaemon(true);
            thread.start();
        }

        public void taskStarted(HMCSession session, PanelModelTaskPortal portal) {
            this.asynchronouslyRefreshTasks();
        }

        public void taskEnded(HMCSession session, PanelModelTaskPortal portal) {
            this.asynchronouslyRefreshTasks();
        }

        public void taskRealized(HMCSession session, PanelModelTaskPortal portal) {
        }

        static /* synthetic */ TaskList access$400(TasksModel x0) {
            return x0.TaskList.this;
        }
    }

    protected class UsersModel
    implements PmTableModel,
    HMCSessionLifeListener,
    HMCSessionListener {
        List sessions;
        int[] selectedRows;
        String idHeader;
        String userHeader;
        String creationTimeHeader;
        String runningTaskHeader;
        String locationHeader;
        String notesHeader;

        UsersModel() {
            this.refreshUsers();
            this.idHeader = TaskList.this.resources.getString("idHeader");
            this.userHeader = TaskList.this.resources.getString("userNameHeader");
            this.creationTimeHeader = TaskList.this.resources.getString("creationTimeHeader");
            this.runningTaskHeader = TaskList.this.resources.getString("runningTaskHeader");
            this.locationHeader = TaskList.this.resources.getString("locationHeader");
            this.notesHeader = TaskList.this.resources.getString("notesHeader");
        }

        private void deregisterListeners() {
            if (this.sessions != null && !this.sessions.isEmpty()) {
                Iterator iterator = this.sessions.iterator();
                while (iterator.hasNext()) {
                    HMCSession hmcSession = (HMCSession)iterator.next();
                    hmcSession.removeHMCSessionListener(this);
                }
            }
        }

        private void registerListeners() {
            if (this.sessions != null && !this.sessions.isEmpty()) {
                Iterator iterator = this.sessions.iterator();
                while (iterator.hasNext()) {
                    HMCSession hmcSession = (HMCSession)iterator.next();
                    hmcSession.addHMCSessionListener(this);
                }
            }
        }

        void prepareForTaskEnd() {
            this.deregisterListeners();
        }

        synchronized void refreshUsers() {
            int i;
            this.deregisterListeners();
            boolean allSelected = this.selectedRows != null && this.sessions != null && this.selectedRows.length == this.sessions.size() && this.selectedRows.length != 1;
            Object[] selectedSessions = null;
            if (!allSelected && this.selectedRows != null && this.sessions != null) {
                selectedSessions = new Object[this.selectedRows.length];
                i = 0;
                while (i < this.selectedRows.length) {
                    selectedSessions[i] = this.sessions.get(i);
                    ++i;
                }
            }
            this.sessions = new ArrayList(HMCSession.getAllSessions());
            this.registerListeners();
            Collections.sort(this.sessions, new Comparator(this){
                private final /* synthetic */ UsersModel this$1;
                {
                    this.this$1 = this$1;
                }

                public int compare(Object o1, Object o2) {
                    return ((HMCSession)o1).getCreationTime().compareTo(((HMCSession)o2).getCreationTime());
                }
            });
            if (allSelected) {
                this.selectedRows = new int[this.sessions.size()];
                i = 0;
                while (i < this.selectedRows.length) {
                    this.selectedRows[i] = i;
                    ++i;
                }
            } else if (selectedSessions != null) {
                ArrayList<Integer> rows = new ArrayList<Integer>(selectedSessions.length);
                int i2 = 0;
                while (i2 < selectedSessions.length) {
                    int index = this.sessions.indexOf(selectedSessions[i2]);
                    if (index != -1) {
                        rows.add(new Integer(index));
                    }
                    ++i2;
                }
                if (rows.isEmpty()) {
                    this.selectedRows = new int[]{this.sessions.indexOf(TaskList.this.getHMCSession())};
                } else {
                    this.selectedRows = new int[rows.size()];
                    Collections.sort(rows);
                    int i3 = 0;
                    while (i3 < this.selectedRows.length) {
                        Integer index = (Integer)rows.get(i3);
                        this.selectedRows[i3] = index;
                        ++i3;
                    }
                }
            } else {
                this.selectedRows = new int[]{this.sessions.indexOf(TaskList.this.getHMCSession())};
            }
            TaskList.this.tasksModel.setSessions(this.getSelectedSessions());
        }

        List getSelectedSessions() {
            ArrayList currentSessions = new ArrayList(this.selectedRows.length);
            int i = 0;
            while (i < this.selectedRows.length) {
                currentSessions.add(this.sessions.get(this.selectedRows[i]));
                ++i;
            }
            return currentSessions;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public int getRowCount() {
            return this.sessions.size();
        }

        public int getColumnCount() {
            return 6;
        }

        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.idHeader;
                }
                case 1: {
                    return this.userHeader;
                }
                case 2: {
                    return this.creationTimeHeader;
                }
                case 3: {
                    return this.runningTaskHeader;
                }
                case 4: {
                    return this.locationHeader;
                }
                case 5: {
                    return this.notesHeader;
                }
            }
            return null;
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 3) {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = TaskList.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            return class$java$lang$String == null ? (class$java$lang$String = TaskList.class$("java.lang.String")) : class$java$lang$String;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            HMCSession session = (HMCSession)this.sessions.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return session.getDisplayableSessionId();
                }
                case 1: {
                    ClientUserContext userContext = session.getUserContext();
                    if (userContext != null) {
                        return userContext.getUserName();
                    }
                    return TaskList.this.localize("unknown");
                }
                case 2: {
                    return TaskList.this.dateformatter.format(session.getCreationTime());
                }
                case 3: {
                    return new Integer(session.getRunningTasks().size());
                }
                case 4: {
                    return this.getLocation(session.getUserContext());
                }
                case 5: {
                    return this.getNote(session);
                }
            }
            return null;
        }

        private String getLocation(ClientUserContext userContext) {
            if (userContext == null) {
                return TaskList.this.localize("unknown");
            }
            try {
                if (userContext.isLocalContext()) {
                    return TaskList.this.localize("localConsoleLocation");
                }
            }
            catch (UnknownHostException e) {
                return TaskList.this.localize("unknown");
            }
            InetAddress clientAddress = userContext.getAddress();
            String hostname = clientAddress.getHostName();
            String ipAddr = clientAddress.getHostAddress();
            String address = hostname.equals(ipAddr) ? ipAddr : hostname + " [" + ipAddr + ']';
            return address;
        }

        private String getNote(HMCSession session) {
            Date time = session.getDisconnectionTime();
            if (time != null) {
                return TaskList.this.localize("disconnectedNote", new Object[]{TaskList.this.dateformatter.format(time)});
            }
            time = session.getLossOfConnectivityTime();
            if (time != null) {
                return TaskList.this.localize("connectivityLostNote", new Object[]{TaskList.this.dateformatter.format(time)});
            }
            if (session == TaskList.this.getHMCSession()) {
                return TaskList.this.localize("yourSessionNote");
            }
            return "";
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            throw new UnsupportedOperationException();
        }

        public void setSelected(int[] selected) {
            this.selectedRows = selected;
        }

        public int[] getSelected() {
            return this.selectedRows;
        }

        private void asynchronouslyRefreshUsers() {
            Thread thread = new Thread(new Runnable(this){
                private final /* synthetic */ UsersModel this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    this.this$1.refreshUsers();
                    UsersModel.access$200((UsersModel)this.this$1).mainPanelModel.refresh();
                }
            }, "TaskList asynchronous users refresh for TaskList task " + TaskList.this.getTaskId());
            thread.setDaemon(true);
            thread.start();
        }

        public void sessionCreated(HMCSession session) {
            Trace.trace(TaskList.TRACE_MASKT, "sessionCreated() for session with id " + session.getSessionId());
            this.asynchronouslyRefreshUsers();
        }

        public void sessionRemoved(HMCSession session) {
            Trace.trace(TaskList.TRACE_MASKT, "sessionRemoved() for session with id " + session.getSessionId());
            this.asynchronouslyRefreshUsers();
        }

        public void sessionDisconnected(HMCSession session) {
            Trace.trace(TaskList.TRACE_MASKT, "sessionDisconnected() for session with id " + session.getSessionId());
            TaskList.this.mainPanelModel.refresh(200);
        }

        public void sessionConnected(HMCSession session) {
            Trace.trace(TaskList.TRACE_MASKT, "sessionConnected() for session with id " + session.getSessionId());
            TaskList.this.mainPanelModel.refresh(200);
        }

        public void sessionDestroyed(HMCSession session) {
            Trace.trace(TaskList.TRACE_MASKT, "sessionDestroyed() for session with id " + session.getSessionId());
            TaskList.this.mainPanelModel.refresh(200);
        }

        public void clientConnectivityLost(HMCSession session) {
            Trace.trace(TaskList.TRACE_MASKT, "clientConnectivityLost() for session with id " + session.getSessionId());
            TaskList.this.mainPanelModel.refresh(200);
        }

        public void clientConnectivityGained(HMCSession session) {
            Trace.trace(TaskList.TRACE_MASKT, "clientConnectivityGained() for session with id " + session.getSessionId());
            TaskList.this.mainPanelModel.refresh(200);
        }

        public void taskStarted(HMCSession session, PanelModelTaskPortal portal) {
            Trace.trace(TaskList.TRACE_MASKT, "taskStarted() for session with id " + session.getSessionId() + " and task with id " + portal.getTaskId());
            TaskList.this.mainPanelModel.refresh(200);
        }

        public void taskEnded(HMCSession session, PanelModelTaskPortal portal) {
            Trace.trace(TaskList.TRACE_MASKT, "taskEnded() for session with id " + session.getSessionId() + " and task with id " + portal.getTaskId());
            TaskList.this.mainPanelModel.refresh(200);
        }

        public void taskRealized(HMCSession session, PanelModelTaskPortal portal) {
        }

        static /* synthetic */ TaskList access$200(UsersModel x0) {
            return x0.TaskList.this;
        }
    }
}

